// Background service worker for Target Budget Sync

// Handle extension installation
chrome.runtime.onInstalled.addListener((details) => {
  if (details.reason === 'install') {
    console.log('Target Budget Sync installed');
    // Open settings page on first install
    chrome.runtime.openOptionsPage();
  } else if (details.reason === 'update') {
    console.log('Target Budget Sync updated to version', chrome.runtime.getManifest().version);
  }
});

// Handle messages from popup or content scripts
chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
  if (request.action === 'sendToServer') {
    sendOrdersToServer(request.orders, request.config)
      .then(response => sendResponse({ success: true, data: response }))
      .catch(error => sendResponse({ success: false, error: error.message }));
    return true; // Keep channel open for async response
  }
});

// Send orders to budget app server
async function sendOrdersToServer(orders, config) {
  const response = await fetch(`${config.serverUrl}/api/target/import`, {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
      'Authorization': `Bearer ${config.apiKey}`
    },
    body: JSON.stringify({
      source: 'target_extension',
      orders: orders
    })
  });

  if (!response.ok) {
    const error = await response.json();
    throw new Error(error.error || `Server returned ${response.status}`);
  }

  return response.json();
}

// Open options page when clicking extension icon on non-Target pages
chrome.action.onClicked.addListener((tab) => {
  if (!tab.url.includes('target.com')) {
    chrome.runtime.openOptionsPage();
  }
});
